note
	description: "class providing the feature to integrate functions"
	author: "Enrico Nardelli"
	date: "Maggio 2021"
	revision: "3.1"

class
	CALCULUS

feature

	compute_integral (f: INTEGRATABLE_FUNCTION; start, finish, step: REAL): REAL_64
		require
			start <= finish
			step > 0
		local
			x: REAL
			i: INTEGER
		do
			from
				x := start
				i := 0
			until
				x >= finish
			loop
				Result := Result + step * f.item (x)
				x := start + i * step
				i := i + 1
			end
		end

end
