note
	description: "class providing the feature to integrate functions"
	author: "Enrico Nardelli"
	date: "Maggio 2021"
	revision: "3.1"

class
	CALCULUS

create
	default_create

feature

	compute_integral (f: FUNCTION [REAL, REAL_64]; start, finish, step: REAL): REAL_64
		require
			start <= finish
			step > 0
			f /= Void
		local
			x: REAL
			i: INTEGER
		do
			from
				x := start
				i := 0
			until
				x >= finish
			loop
			Result := Result + step * f.item (x)
-- mid point interpolation
--			Result := Result + step * (f.item ([x + step]) + f.item ([x])) / 2
				x := start + i * step
				i := i + 1
			end
		end

end -- class CALCULUS

