note
	description: "Summary description for {PERSONA}."
	author: "Enrico Nardelli"
	date: "Maggio 2021"
	revision: "3.1"

class
	PERSONA

create
	make_complete

feature

	nome: STRING

	eta: INTEGER

	stipendio: INTEGER

	make_complete (p_nome: STRING; p_eta: INTEGER; p_stipendio: INTEGER)
		do
			nome := p_nome
			eta := p_eta
			stipendio := p_stipendio
		end

	set_nome (nuovo_nome: STRING)
		do
			nome := nuovo_nome
		ensure
			nome = nuovo_nome
		end

	set_eta (nuova_eta: INTEGER)
		require
			nuova_eta > 0
		do
			eta := nuova_eta
		ensure
			eta = nuova_eta
		end

	set_stipendio (nuovo_stipendio: INTEGER)
		require
			nuovo_stipendio > 0
		do
			stipendio := nuovo_stipendio
		ensure
			stipendio = nuovo_stipendio
		end

	incrementa_stipendio (aumento: INTEGER)
		require
			aumento > 0
		do
			set_stipendio (stipendio + aumento)
		ensure
			stipendio = old stipendio + aumento
		end

	stampa
		do
			print ("nome: ");
			print (nome);
			print (";  ")
			print ("eta: ");
			print (eta);
			print (";  ")
			print ("stipendio: ");
			print (stipendio);
			print ("%N")
		end -- feature stampa

end
