import java.util.*;

/**
 * A class for converting weight on a planet.
 *
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class Planet {

   private String name;   // name of the planet
   private double factor; // weight factor used for the conversion

   /**
    * Constructs a given planet.
    * 
    * @param namePlanet
    *           the name of the planet
    * @param factorWeight
    *           the weight factor
    */
   public Planet(String namePlanet, double factorWeight) {
      name = namePlanet;
      factor = factorWeight;
   }

   /**
    * Converts a weight from Earth to the other planet.
    * 
    * @param weight
    *           the weight to be converted (from Earth)
    * @return the converted value
    */
   public double convert(double weight) {
      return weight * factor;
   }

   /**
    * Converts a weight from the other planet to Earth.
    * 
    * @param weight
    *           the weight to be converted (to Earth)
    * @return the converted value
    */
   public double convertInverse(double weight) {
      return weight / factor;
   }

   /**
    * Gives the weight factor of the planet.
    * 
    * @return the weight factor of the planet
    */
   public double getFactor() {
      return factor;
   }

   /**
    * Gives the name of the planet.
    * 
    * @return the name of the planet
    */
   public String getName() {
      return name;
   }

   /**
    * A small test of the Planet class.
    */
   public static void main(String[] arguments) {
      // Initialize planet conversion factor
      Planet mercury = new Planet("Mercury", 0.4);
      
      // Read your weight and its unit     
      Scanner reader = new Scanner(System.in);
      System.out.print("Weight unit: ");
      String unit = reader.next();
      System.out.print("Your weight on Earth (in " + unit + "): ");
      double weight = reader.nextDouble();
      reader.close();
      
      // Print corresponding weight on the planet
      System.out.println("Your weight on " + mercury.getName() + " (in " + unit + "): " + mercury.convert(weight));
   }

}
