import java.util.*;

/**
 * A class for converting weights with respect to different planets.
 *
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class WeightConverter {

   public static void main(String[] arguments) {
      // Initialize planet conversion factors
      Planet mercury = new Planet("Mercury", 0.4);
      Planet venus   = new Planet("Venus",   0.9);
      Planet mars    = new Planet("Mars",    0.4);
      Planet jupiter = new Planet("Jupiter", 2.4);
      Planet saturn  = new Planet("Saturn",  1.1);
      
      // Read your weight and its unit     
      Scanner reader = new Scanner(System.in);
      System.out.print("Weight unit: ");
      String unit = reader.next();
      System.out.print("Your weight on Earth (in " + unit + "): ");
      double weight = reader.nextDouble();
      reader.close();
      
      // Print corresponding weights on the planets
      System.out.println();
      System.out.println("WEIGHT OVERVIEW");
      System.out.println("Earth: " + weight + unit);
      System.out.println(mercury.getName() + ": " + mercury.convert(weight) + unit);
      System.out.println(venus.getName()   + ": " + venus.convert(weight)   + unit);
      System.out.println(mars.getName()    + ": " + mars.convert(weight)    + unit);
      System.out.println(jupiter.getName() + ": " + jupiter.convert(weight) + unit);
      System.out.println(saturn.getName()  + ": " + saturn.convert(weight)  + unit);      
   }

}
