/**
 * A book can be borrowed and returned.
 *
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class Book {

   private String title;      // title of book
   private boolean available; // status of book

   /**
    * Constructs a book with a given title; it is available to be borrowed.
    * 
    * @param titleBook
    *           the title of the book
    */
   public Book(String titleBook) {
      title = titleBook;
      available = true;
   }

   /**
    * Marks the book as not available.
    */
   public void borrowed() {
      available = false;
   }

   /**
    * Marks the book as available.
    */
   public void returned() {
      available = true;
   }

   /**
    * Indicates whether the book is available or not.
    * 
    * @return the availability status of the book
    */
   public boolean isAvailable() {
      return available;
   }

   /**
    * Gives the title of the book.
    * 
    * @return the title of the book
    */
   public String getTitle() {
      return title;
   }

   /**
    * A small test of the Book class.
    */
   public static void main(String[] arguments) {
      Book book = new Book("The Da Vinci Code");
      System.out.println("Title (should be The Da Vinci Code): " + book.getTitle());
      System.out.println("Available? (should be true): " + book.isAvailable());
      book.borrowed();
      System.out.println("Available? (should be false): " + book.isAvailable());
      book.returned();
      System.out.println("Available? (should be true): " + book.isAvailable());
   }

}
