/**
 * A library where books can be borrowed and returned.
 * 
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class Library {

   private String address; // address of library
   private int bookTotal; // total number of books
   private int bookCapacity; // maximum book capacity
   private Book[] bookCollection; // collection of books

   /**
    * Constructs a library with a given address and an empty book collection.
    * 
    * @param addressLibrary
    *           the address of the library
    */
   public Library(String addressLibrary) {
      address = addressLibrary;
      bookTotal = 0;
      bookCapacity = 100;
      bookCollection = new Book[bookCapacity];
   }

   /**
    * Adds a book to the collection as long as the maximum book capacity is not reached.
    * 
    * @param book
    *           the book to be added
    */
   public void addBook(Book book) {
      if (book != null && bookTotal < bookCapacity) {
         book.returned();
         bookCollection[bookTotal] = book;
         bookTotal++;
      } else {
         System.out.println("Sorry, the book could not be added");
      }
   }

   /**
    * Borrows a book from the library.
    * 
    * @param book
    *           the title of the book
    */
   public void borrowBook(String title) {
      int status = 0; 
         // 0 = book is not in catalog
         // 1 = book is borrowed 
         // 2 = book is available
      if (title != null) {
         for (int i = 0; i < bookTotal && status != 2; i++) {
            if (title.equals(bookCollection[i].getTitle())) {
               if (bookCollection[i].isAvailable()) {
                  bookCollection[i].borrowed();
                  status = 2;
               } else {
                  status = 1;               
               }
            }
         }
      }
      switch (status) {
         case 0:
            System.out.println("Sorry, this book is not in our catalog");
            break;
         case 1:
            System.out.println("Sorry, this book is already borrowed");
            break;
         case 2:
            System.out.println("You successfully borrowed " + title);
      }
   }

   /**
    * Returns a book to the library.
    * 
    * @param book
    *           the title of the book
    */
   public void returnBook(String title) {
      int status = 0;  
         // 0 = book is not in catalog
         // 1 = book is borrowed 
         // 2 = book is available
      if (title != null) {
         for (int i = 0; i < bookTotal && status != 1; i++) {
            if (title.equals(bookCollection[i].getTitle())) {
               if (bookCollection[i].isAvailable()) {
                  status = 2;
               } else {
                  bookCollection[i].returned();
                  status = 1;               
               }
            }
         }
      }
      switch (status) {
         case 0:
            System.out.println("Sorry, this book is not in our catalog");
            break;
         case 1:
            System.out.println("You successfully returned " + title);
            break;
         case 2:
            System.out.println("Sorry, this book is already returned");
      }
   }

   /**
    * Gives the maximum capacity of books that can be stored.
    * 
    * @return the maximum book capacity
    */
   public int getBookCapacity() {
      return bookCapacity;
   }

   /**
    * Prints the list of available books in the library.
    */
   public void printAvailableBooks() {
      if (bookTotal > 0) {
         boolean available = false;
         for (int i = 0; i < bookTotal; i++) {
            if (bookCollection[i].isAvailable()) {
               System.out.println(bookCollection[i].getTitle());
               available = true;
            }
         }
         if (!available) {
            System.out.println("No book available");
         }
      } else {
         System.out.println("No book in the catalog");
      }
   }

   /**
    * Prints the address of the library.
    */
   public void printAddress() {
      System.out.println(address);
   }

   /**
    * Prints the opening hours of the library.
    */
   public static void printOpeningHours() {
      System.out.println("Libraries are open daily from 9:00 to 17:00");
   }

   /**
    * A small test of the Library class.
    */
   public static void main(String[] args) {
      // Create two libraries
      Library firstLibrary = new Library("Main Street 10");
      Library secondLibrary = new Library("Liberty Street 228");

      // Add four books to the first library
      firstLibrary.addBook(new Book("The Da Vinci Code"));
      firstLibrary.addBook(new Book("Le Petit Prince"));
      firstLibrary.addBook(new Book("A Tale of Two Cities"));
      firstLibrary.addBook(new Book("The Lord of the Rings"));

      // Print opening hours and the addresses
      System.out.println("Library hours:");
      Library.printOpeningHours();
      System.out.println();

      System.out.println("Library addresses:");
      firstLibrary.printAddress();
      secondLibrary.printAddress();
      System.out.println();

      // Try to borrow The Lords of the Rings from both libraries
      System.out.println("Borrowing The Lord of the Rings:");
      firstLibrary.borrowBook("The Lord of the Rings");
      firstLibrary.borrowBook("The Lord of the Rings");
      secondLibrary.borrowBook("The Lord of the Rings");
      System.out.println();

      // Print the titles of all available books from both libraries
      System.out.println("Books available in the first library:");
      firstLibrary.printAvailableBooks();
      System.out.println();
      System.out.println("Books available in the second library:");
      secondLibrary.printAvailableBooks();
      System.out.println();

      // Return The Lords of the Rings to the first library
      System.out.println("Returning The Lord of the Rings:");
      firstLibrary.returnBook("The Lord of the Rings");
      System.out.println();

      // Print the titles of available from the first library
      System.out.println("Books available in the first library:");
      firstLibrary.printAvailableBooks();
   }

}
