/**
 * A class for printing text to the console.
 * 
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class ConsolePrinter implements TextPrinter {

   /**
    * Constructs a console listener.
    */
   public ConsolePrinter() {
   }

   /**
    * Prints a given text to the console.
    * 
    * @param text
    *           the given text
    */
   public void print(String text) {
      System.out.print(text);
   }

   /**
    * Prints a given text to the console and then terminates the line.
    * 
    * @param text
    *           the given text
    */
   public void println(String text) {
      System.out.println(text);
   }

   /**
    * Terminates the line on the console.
    */
   public void println() {
      System.out.println();
   }

}
