/**
 * A class for printing to a text frame.
 * 
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class TextFramePrinter implements TextPrinter {

   protected TextFrame frame;

   /**
    * Constructs a text listener with a given text frame.
    * 
    * @param frame
    *           the given text frame
    */
   public TextFramePrinter(TextFrame frame) {
      this.frame = frame;
   }

   /**
    * Prints a given text to the text field.
    * 
    * @param text
    *           the given text
    */
   public void print(String text) {
      if (frame != null) frame.addText(text);
   }

   /**
    * Prints a given text to the text field and then terminates the line.
    * 
    * @param text
    *           the given text
    */
   public void println(String text) {
      if (frame != null) frame.addText(text + "\n");
   }

   /**
    * Terminates the line on the text field.
    */
   public void println() {
      if (frame != null) frame.addText("\n");
   }

}
