/**
 * A class for generating and printing text patterns.
 * 
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class TextPattern_prelim {

   /**
    * Sends a given text to the console.
    * 
    * @param text
    *           the given text
    */
   public void print(String text) {
      System.out.print(text);
   }

   /**
    * Sends a given text to the console and then terminates the line.
    * 
    * @param text
    *           the given text
    */
   public void println(String text) {
      System.out.println(text);
   }

   /**
    * Terminates the line on the console.
    */
   public void println() {
      System.out.println();
   }

   /**
    * Sends a square text pattern to the console.
    * 
    * @param height
    *           the height of the square
    */
   public void printSquare(int height) {
      for (int i = 1; i <= height; i++) {
         for (int j = 1; j <= height; j++) {
            print("x");
         }
         println();
      }
   }

   /**
    * Sends a triangle text pattern to the console.
    * 
    * @param height
    *           the height of the triangle
    */
   public void printTriangle(int height) {
      for (int i = 1; i <= height; i++) {
         for (int j = 1; j <= i; j++) {
            print("x");
         }
         println();
      }
   }

   /**
    * Sends a pyramid text pattern to the console.
    * 
    * @param height
    *           the height of the pyramid
    */
   public void printPyramid(int height) {
      for (int i = 1; i <= height; i++) {
         for (int j = 1; j <= (height - i); j++) {
            print(" ");
         }
         for (int j = 1; j <= (2 * i - 1); j++) {
            print("x");
         }
         println();
      }
   }

   /**
    * A small test of the TextPattern class (preliminary version).
    */
   public static void main(String[] args) {
      // Print some text patterns to the console
      TextPattern_prelim pattern = new TextPattern_prelim();
      pattern.println("a triangle:");
      pattern.printTriangle(5);
      pattern.println();
      pattern.println("a square:");
      pattern.printSquare(5);
      pattern.println();
      pattern.println("a pyramid:");
      pattern.printPyramid(5);
   }

}
