import java.awt.*;

/**
 * A demo class for drawing a polygon. 
 * 
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */

public class DemoGraphicsFrame extends GraphicsFrame {

   private static final long serialVersionUID = 1L;

   /**
    * Constructs a demo graphics frame.
    */
   public DemoGraphicsFrame() {
      super("Demo Graphics Frame");
   }

   /**
    * Draws a regular polygon with n points.
    * 
    * @param n
    *           the number of polygon points
    * @param filled
    *           the polygon is filled or not
    */
   public void drawRegularPolygon(int n, boolean filled) {
      if (n > 2) {
         GraphicsPanel graphics = getGraphicsPanel();

         int xc = graphics.getWidth() / 2;
         int yc = graphics.getHeight() / 2;
         int radius = Math.min(xc, yc) - 10;

         Point[] points = new Point[n];
         for (int i = 0; i < n; i++) {
            int x = xc + (int) (radius * Math.cos(2.0 * Math.PI * i / n));
            int y = yc + (int) (radius * Math.sin(2.0 * Math.PI * i / n));
            points[i] = new Point(x, y);
         }

         graphics.clear();
         graphics.setDrawColor(Color.BLUE);
         graphics.drawPolygon(points, filled);
         graphics.repaint();
      }
   }

   /**
    * A small test of the DemoGraphicsFrame class.
    */
   public static void main(String[] args) {
      // Construct the graphics frame
      DemoGraphicsFrame frame = new DemoGraphicsFrame();
      frame.setGraphicsDimension(500, 500);
      frame.setResizable(false);
      frame.start();

      // Draw a polygon
      String msgN = "What is the number of polygon points?";
      int n = frame.showInputDialogInt(msgN, 8);
      frame.drawRegularPolygon(n, true);
   }

}
