import java.awt.*;

/**
 * A JFrame for showing a random balls.
 * 
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class RandomBalls extends AnimationGraphicsFrame {

   private static final long serialVersionUID = 1L;
   private int radius;
   private int diameter;

   /**
    * Constructs an animation frame for random balls.
    */
   public RandomBalls() {
      this(20);
   }

   /**
    * Constructs an animation frame for random balls.
    * 
    * @param radius
    *           the radius of the balls
    */
   public RandomBalls(int radius) {
      super("Random Balls");
      setRadius(radius);
   }

   /**
    * Sets the radius of the balls.
    * 
    * @param radius
    *           the radius of the balls
    */
   public void setRadius(int radius) {
      this.radius = (radius > 1) ? radius : 1;
      this.diameter = 2 * this.radius;
   }

   /**
    * Initializes a new animation (is called before the start of the animation).
    */
   protected void animateInit() {
      clearGraphics();
      setAnimationDelay(500);
   }

   /**
    * Executes the next step in the animation.
    */
   protected void animateNext() {
      GraphicsPanel graphics = getGraphicsPanel();
      int x = (int) (Math.random() * (graphics.getWidth() - diameter));
      int y = (int) (Math.random() * (graphics.getHeight() - diameter));
      int red = (int) (Math.random() * 256);
      int green = (int) (Math.random() * 256);
      int blue = (int) (Math.random() * 256);
      graphics.setDrawColor(new Color(red, green, blue));
      graphics.drawOval(x, y, diameter, diameter, true);
      graphics.repaint();
   }

   /**
    * Finalizes the animation (is called after the end of the animation).
    */
   protected void animateFinal() {
      clearGraphics();
   }

   /**
    * A small test of the RandomBalls class.
    */
   public static void main(String[] args) {
      RandomBalls frame = new RandomBalls();
      frame.setGraphicsDimension(500, 500);
      frame.start();
   }

}
