/**
 * A baby that needs to eat and grow.
 * 
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class Baby {

   private String name;    // name
   private boolean isMale; // sex
   private double weight;  // weight (kg)
   private int nbPoops;    // number of poops so far
   private static int nbBabiesMade = 0; // total number of babies

   /**
    * Makes a new baby with a name, sex and weight.
    *
    * @param newName
    *           the new name
    * @param newIsMale
    *           the new sex
    * @param newWeight
    *           the new weight
    */
   public Baby(String newName, boolean newIsMale, double newWeight) {
      name = newName;
      isMale = newIsMale;
      weight = newWeight;
      nbPoops = 0;
      nbBabiesMade = nbBabiesMade + 1;
   }

   /**
    * Says hello and the name.
    */
   public void sayHi() {
      System.out.println("Hi, my name is " + name);
   }

   /**
    * Eats some food to increase the weight.
    * 
    * @param food
    *           the amount of food
    */
   public void eat(double food) {
      weight = weight + food;
   }

   /**
    * Poops once more.
    */
   public void poop() {
      nbPoops = nbPoops + 1;
      System.out.println("Mam, I have pooped. Ready the diaper.");
   }

   /**
    * Gives the name of the baby.
    * 
    * @return the name
    */
   public String getName() {
      return name;
   }

   /**
    * Gives the sex of the baby.
    * 
    * @return is male or not
    */
   public boolean isSexMale() {
      return isMale;
   }

   /**
    * Gives the weight of the baby.
    * 
    * @return the weight
    */
   public double getWeight() {
      return weight;
   }

   /**
    * Gives the number of poops so far.
    * 
    * @return the number
    */
   public int getNbPoops() {
      return nbPoops;
   }

   /**
    * Gives the total number of babies made.
    * 
    * @return the number
    */
   public static int getNbBabiesMade() {
      return nbBabiesMade;
   }

   /**
    * A small test of the Baby class.
    */
   public static void main(String[] args) {
      System.out.println("A new baby is born!");
      Baby david = new Baby("David", true, 4.0);
      david.sayHi();
      david.eat(0.1);
      david.poop();
      System.out.println("Total number of babies so far: "
            + Baby.getNbBabiesMade());
   }

}
