import java.util.*;

/**
 * A bank account has a balance that can be changed by deposits and withdrawals.
 *
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class BankAccount {

   private double balance; // balance (EUR)

   /**
    * Constructs a bank account with a zero balance.
    */
   public BankAccount() {
      balance = 0.0;
   }

   /**
    * Constructs a bank account with a given balance.
    * 
    * @param initBalance
    *           the initial balance
    */
   public BankAccount(double initBalance) {
      balance = initBalance;
   }

   /**
    * Gives the current balance of the bank account.
    * 
    * @return the current balance
    */
   public double getBalance() {
      return balance;
   }

   /**
    * Deposits money into the bank account.
    * 
    * @param amount
    *           the amount to deposit
    */
   public void deposit(double amount) {
      balance = balance + amount;
   }

   /**
    * Withdraws money from the bank account.
    * 
    * @param amount
    *           the amount to withdraw
    */
   public void withdraw(double amount) {
      balance = balance - amount;
   }

   /**
    * Adds interest to the bank account.
    * 
    * @param rate
    *           the interest rate
    * @return the computed interest
    */
   public double addInterest(double rate) {
      double interest = balance * rate;
      balance = balance + interest;
      return interest;
   }

   /**
    * A small test of the BankAccount class.
    */
   public static void main(String[] args) {
      BankAccount account = new BankAccount();
      Scanner reader = new Scanner(System.in);
      System.out.print("Deposit in Euro: ");
      account.deposit(reader.nextDouble());
      reader.close();
      System.out.println("Account Balance: " + account.getBalance() + "EUR");
    }

}
