
public class InterFaceEx {
   public static void main(String[] args) {
      I1 i1 = new B();
      i1.methodI1(); // OK as methodI1 is present in B1
      // i1.methodI2(); Compilation error as methodI2 not present in I1

      // Casting to convert the type of the reference from type I1 to type I2
      ((I2) i1).methodI2();

      I2 i2 = new B();
      i2.methodI1(); // OK
      i2.methodI2(); // OK

      // Does not Compile as methodA1() not present in interface reference I1
      // String var = i1.methodA1();
      // Hence I1 requires a cast to invoke methodA1

      String var2 = ((A) i1).methodA1();
      System.out.println("var2 : " + var2);
      String var3 = ((B) i1).methodA1();
      System.out.println("var3 : " + var3);
      String var4 = ((A) i1).methodA2();
      System.out.println("var4 : " + var4);
      String var5 = ((B) i1).methodA2();
      System.out.println("var5 : " + var5);
      String var6 = i1.toString();
      System.out.println("var6 : " + var6);
      String var7 = i2.toString();
      System.out.println("var7 : " + var7);

      I1 i3 = new C();
      String var8 = i3.toString();
      System.out.println("var8 : " + var8); // Prints the Object toString() 

      Object o1 = new B();
      // o1.methodI1(); Does not compile as Object does not define methodI1()
      // To solve the problem we need to downcast o1 reference
      // We can do it in the following 4 ways:
      ((I1) o1).methodI1(); // 1
      ((I2) o1).methodI1(); // 2
       ((B) o1).methodI1(); // 3

      // B does not have any relationship with C except they are "siblings"
      // Well, you cannot cast siblings into one another
      // ((C)o1).methodI1(); // 4: Produces a ClassCastException
   }
}
