/**
 * A class for printing shopping receipts.
 * 
 * @author Hendrik Speleers
 * @author NMCGJ, AY 2025-2026
 */
public class Receipt {

   private double total = 0.0; // total cost

   /**
    * Prints the title of the receipt.
    */
   public void printTitle() {
      formatItem("Item", "Qty", "Price");
      formatItem("----", "---", "-----");
   }

   /**
    * Prints a shopping item onto the receipt.
    * 
    * @param name
    *           a description of the item
    * @param quantity
    *           the quantity of this item bought
    * @param price
    *           the price of this item
    */
   public void printItem(String name, int quantity, double price) {
      formatItem(name, quantity, price);
      total += price;
   }

   /**
    * Prints the total cost onto the receipt.
    */
   public void printTotal() {
      formatItem("", "", "-----");
      formatTotal("Total", total);
   }

   /**
    * Formats a shopping item onto the receipt.
    * 
    * @param name
    *           a description of the item
    * @param quantity
    *           the quantity of this item bought
    * @param price
    *           the price of this item
    */
   private void formatItem(String name, String quantity, String price) {
      System.out.format("%-20.20s %5.5s %10.10s\n", name, quantity, price);
   }

   /**
    * Formats a shopping item onto the receipt.
    * 
    * @param name
    *           a description of the item
    * @param quantity
    *           the quantity of this item bought
    * @param price
    *           the price of this item
    */
   private void formatItem(String name, int quantity, double price) {
      System.out.format("%-20.20s %5d %10.2f\n", name, quantity, price);
   }

   /**
    * Formats the total cost onto the receipt.
    * 
    * @param name
    *           a description of the cost
    * @param total
    *           the total cost
    */
   private void formatTotal(String name, double total) {
      System.out.format("%-20.20s  %15.2f\n", name, total);
   }

   /**
    * A small test of the Receipt class.
    */
   public static void main(String[] args) {
      Receipt receipt = new Receipt();
      receipt.printTitle();
      receipt.printItem("Jack's Magic Beans", 4, 4.25);
      receipt.printItem("Princess Peas", 3, 5.1);
      receipt.printItem("Three Bears Porridge", 1, 14.29);
      receipt.printTotal();
   }

}
